// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Tabs.pas' rev: 10.00

#ifndef TabsHPP
#define TabsHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Imglist.hpp>	// Pascal unit
#include <Comctrls.hpp>	// Pascal unit
#include <Extctrls.hpp>	// Pascal unit
#include <Menus.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Tabs
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TScrollBtn { sbLeft, sbRight };
#pragma option pop

#pragma option push -b-
enum TScrollOrientation { soLeftRight, soUpDown };
#pragma option pop

class DELPHICLASS TScroller;
class PASCALIMPLEMENTATION TScroller : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	int FMin;
	int FMax;
	int FPosition;
	Classes::TNotifyEvent FOnClick;
	int FChange;
	TScrollOrientation FScrollOrientation;
	Graphics::TBitmap* FBitmap;
	bool FPressed;
	bool FDown;
	TScrollBtn FCurrent;
	int FWidth;
	int FHeight;
	Extctrls::TTimer* FDownTimer;
	void __fastcall SetMin(int Value);
	void __fastcall SetMax(int Value);
	void __fastcall SetPosition(int Value);
	bool __fastcall CanScrollLeft(void);
	bool __fastcall CanScrollRight(void);
	HIDESBASE void __fastcall DoMouseDown(int X);
	HIDESBASE MESSAGE void __fastcall WMLButtonDown(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMLButtonDblClk(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMMouseMove(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMLButtonUp(Messages::TWMMouse &Message);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Message);
	void __fastcall SetScrollOrientation(const TScrollOrientation Value);
	void __fastcall DoScrollTimer(System::TObject* Sender);
	
public:
	__fastcall virtual TScroller(Classes::TComponent* AOwner);
	__fastcall virtual ~TScroller(void);
	virtual void __fastcall Paint(void);
	
__published:
	__property Classes::TNotifyEvent OnClick = {read=FOnClick, write=FOnClick};
	__property int Min = {read=FMin, write=SetMin, default=0};
	__property int Max = {read=FMax, write=SetMax, default=0};
	__property int Position = {read=FPosition, write=SetPosition, default=0};
	__property TScrollOrientation ScrollOrientation = {read=FScrollOrientation, write=SetScrollOrientation, nodefault};
	__property int Change = {read=FChange, write=FChange, default=1};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TScroller(HWND ParentWindow) : Controls::TCustomControl(ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TTabList;
class DELPHICLASS TTabSet;
#pragma option push -b-
enum TTabSetTabStyle { tsStandard, tsOwnerDraw, tsSoftTabs, tsModernTabs, tsModernPopout };
#pragma option pop

typedef void __fastcall (__closure *TMeasureTabEvent)(System::TObject* Sender, int Index, int &TabWidth);

typedef void __fastcall (__closure *TTabSetDrawTabEvent)(System::TObject* Sender, Graphics::TCanvas* TabCanvas, const Types::TRect &R, int Index, bool Selected);

typedef void __fastcall (__closure *TTabChangeEvent)(System::TObject* Sender, int NewTab, bool &AllowChange);

#pragma option push -b-
enum TEdgeType { etNone, etFirstIsSel, etFirstNotSel, etLastIsSel, etLastNotSel, etNotSelToSel, etSelToNotSel, etNotSelToNotSel };
#pragma option pop

class PASCALIMPLEMENTATION TTabSet : public Controls::TCustomControl 
{
	typedef Controls::TCustomControl inherited;
	
private:
	int FStartMargin;
	int FEndMargin;
	Classes::TStrings* FTabs;
	int FTabIndex;
	int FFirstIndex;
	int FVisibleTabs;
	Graphics::TColor FSelectedColor;
	Graphics::TColor FUnselectedColor;
	Graphics::TColor FBackgroundColor;
	bool FDitherBackground;
	bool FAutoScroll;
	TTabSetTabStyle FStyle;
	int FOwnerDrawHeight;
	TMeasureTabEvent FOnMeasureTab;
	TTabSetDrawTabEvent FOnDrawTab;
	TTabChangeEvent FOnChange;
	Controls::TImageList* FEdgeImageList;
	Graphics::TBitmap* FMemBitmap;
	Graphics::TBitmap* FBrushBitmap;
	Classes::TList* FTabPositions;
	Classes::TList* FSortedTabPositions;
	int FTabHeight;
	TScroller* FScroller;
	bool FDoFix;
	bool FSoftTop;
	Imglist::TCustomImageList* FImages;
	Imglist::TChangeLink* FImageChangeLink;
	Comctrls::TTabGetImageEvent FOnGetImageIndex;
	bool FShrinkToFit;
	int FEdgeWidth;
	Comctrls::TTabPosition FTabPosition;
	void __fastcall SetSelectedColor(Graphics::TColor Value);
	void __fastcall SetUnselectedColor(Graphics::TColor Value);
	void __fastcall SetBackgroundColor(Graphics::TColor Value);
	void __fastcall SetDitherBackground(bool Value);
	void __fastcall SetAutoScroll(bool Value);
	void __fastcall SetStartMargin(int Value);
	void __fastcall SetEndMargin(int Value);
	void __fastcall SetFirstIndex(int Value);
	void __fastcall SetTabList(Classes::TStrings* Value);
	void __fastcall SetTabStyle(TTabSetTabStyle Value);
	void __fastcall SetTabHeight(int Value);
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Message);
	MESSAGE void __fastcall WMGetDlgCode(Messages::TWMNoParams &Message);
	HIDESBASE MESSAGE void __fastcall CMDialogChar(Messages::TWMKey &Message);
	HIDESBASE MESSAGE void __fastcall CMSysColorChange(Messages::TMessage &Message);
	HIDESBASE MESSAGE void __fastcall CMFontChanged(Messages::TMessage &Message);
	void __fastcall PaintEdge(int X, int Y, int H, TEdgeType Edge);
	void __fastcall CreateBrushPattern(Graphics::TBitmap* Bitmap);
	int __fastcall CalcTabPositions(const int AStart, const int AStop, Graphics::TCanvas* Canvas, int First, bool FullTabs);
	void __fastcall CreateScroller(void);
	void __fastcall InitBitmaps(void);
	void __fastcall DoneBitmaps(void);
	void __fastcall CreateEdgeParts(void);
	void __fastcall FixTabPos(void);
	void __fastcall ScrollClick(System::TObject* Sender);
	void __fastcall SetSoftTop(const bool Value);
	void __fastcall SetImages(const Imglist::TCustomImageList* Value);
	int __fastcall ScrollerSize(void);
	void __fastcall SetShrinkToFit(const bool Value);
	void __fastcall SetTabPosition(const Comctrls::TTabPosition Value);
	void __fastcall SetFontOrientation(Graphics::TCanvas* ACanvas);
	void __fastcall DrawLine(Graphics::TCanvas* Canvas, int FromX, int FromY, int ToX, int ToY);
	void __fastcall ImageListChange(System::TObject* Sender);
	void __fastcall DoDefaultPainting(void);
	void __fastcall DoModernPainting(void);
	void __fastcall DoPopoutModernPainting(void);
	void __fastcall SetupTabPositions(void);
	bool __fastcall ScrollerShown(void);
	
protected:
	bool __fastcall CanChange(int NewIndex);
	HIDESBASE MESSAGE void __fastcall CMHintShow(Forms::TCMHintShow &Message);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	virtual void __fastcall DrawTab(Graphics::TCanvas* TabCanvas, const Types::TRect &R, int Index, bool Selected);
	DYNAMIC void __fastcall GetChildren(Classes::TGetChildProc Proc, Classes::TComponent* Root);
	virtual int __fastcall GetImageIndex(int TabIndex);
	virtual void __fastcall MeasureTab(int Index, int &TabWidth);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int Y);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	virtual void __fastcall Paint(void);
	__property TScroller* Scroller = {read=FScroller};
	virtual void __fastcall SetTabIndex(int Value);
	
public:
	__fastcall virtual TTabSet(Classes::TComponent* AOwner);
	__fastcall virtual ~TTabSet(void);
	int __fastcall ItemAtPos(const Types::TPoint &Pos, bool IgnoreTabHeight = false);
	Types::TRect __fastcall ItemRect(int Index);
	int __fastcall ItemWidth(int Index);
	Types::TRect __fastcall MinClientRect()/* overload */;
	Types::TRect __fastcall MinClientRect(bool IncludeScroller)/* overload */;
	Types::TRect __fastcall MinClientRect(int TabCount, bool IncludeScroller = false)/* overload */;
	HIDESBASE void __fastcall SelectNext(bool Direction);
	__property Canvas ;
	__property int FirstIndex = {read=FFirstIndex, write=SetFirstIndex, default=0};
	
__published:
	__property Align  = {default=0};
	__property Anchors  = {default=3};
	__property bool AutoScroll = {read=FAutoScroll, write=SetAutoScroll, default=1};
	__property Graphics::TColor BackgroundColor = {read=FBackgroundColor, write=SetBackgroundColor, default=-16777201};
	__property Constraints ;
	__property bool DitherBackground = {read=FDitherBackground, write=SetDitherBackground, default=1};
	__property DragCursor  = {default=-12};
	__property DragKind  = {default=0};
	__property DragMode  = {default=0};
	__property Enabled  = {default=1};
	__property int EndMargin = {read=FEndMargin, write=SetEndMargin, default=5};
	__property Font ;
	__property Imglist::TCustomImageList* Images = {read=FImages, write=SetImages};
	__property ParentBackground  = {default=0};
	__property ParentShowHint  = {default=1};
	__property PopupMenu ;
	__property ShowHint ;
	__property bool ShrinkToFit = {read=FShrinkToFit, write=SetShrinkToFit, default=0};
	__property int StartMargin = {read=FStartMargin, write=SetStartMargin, default=5};
	__property Graphics::TColor SelectedColor = {read=FSelectedColor, write=SetSelectedColor, default=-16777201};
	__property bool SoftTop = {read=FSoftTop, write=SetSoftTop, default=0};
	__property TTabSetTabStyle Style = {read=FStyle, write=SetTabStyle, default=0};
	__property int TabHeight = {read=FOwnerDrawHeight, write=SetTabHeight, default=20};
	__property Classes::TStrings* Tabs = {read=FTabs, write=SetTabList};
	__property int TabIndex = {read=FTabIndex, write=SetTabIndex, default=-1};
	__property Comctrls::TTabPosition TabPosition = {read=FTabPosition, write=SetTabPosition, default=1};
	__property Graphics::TColor UnselectedColor = {read=FUnselectedColor, write=SetUnselectedColor, default=-16777211};
	__property Visible  = {default=1};
	__property int VisibleTabs = {read=FVisibleTabs, nodefault};
	__property OnAlignInsertBefore ;
	__property OnAlignPosition ;
	__property OnClick ;
	__property TTabChangeEvent OnChange = {read=FOnChange, write=FOnChange};
	__property OnDragDrop ;
	__property OnDragOver ;
	__property TTabSetDrawTabEvent OnDrawTab = {read=FOnDrawTab, write=FOnDrawTab};
	__property OnEndDock ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property Comctrls::TTabGetImageEvent OnGetImageIndex = {read=FOnGetImageIndex, write=FOnGetImageIndex};
	__property OnMouseActivate ;
	__property OnMouseDown ;
	__property OnMouseEnter ;
	__property OnMouseLeave ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property TMeasureTabEvent OnMeasureTab = {read=FOnMeasureTab, write=FOnMeasureTab};
	__property OnStartDock ;
	__property OnStartDrag ;
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TTabSet(HWND ParentWindow) : Controls::TCustomControl(ParentWindow) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TTabList : public Classes::TStringList 
{
	typedef Classes::TStringList inherited;
	
private:
	TTabSet* FTabSet;
	
public:
	__fastcall TTabList(const TTabSet* ATabSet);
	virtual void __fastcall Insert(int Index, const AnsiString S);
	virtual void __fastcall Delete(int Index);
	virtual int __fastcall Add(const AnsiString S);
	virtual void __fastcall Put(int Index, const AnsiString S);
	virtual void __fastcall Clear(void);
	virtual void __fastcall AddStrings(Classes::TStrings* Strings);
public:
	#pragma option push -w-inl
	/* TStringList.Destroy */ inline __fastcall virtual ~TTabList(void) { }
	#pragma option pop
	
};


#pragma option push -b-
enum TEdgePart { epSelectedLeft, epUnselectedLeft, epSelectedRight, epUnselectedRight };
#pragma option pop

typedef TTabSetTabStyle TTabStyle;

typedef void __fastcall (__closure *TDrawTabEvent)(System::TObject* Sender, Graphics::TCanvas* TabCanvas, const Types::TRect &R, int Index, bool Selected);

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Tabs */
using namespace Tabs;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Tabs
